<?php
/**
* @package Joomla
* @subpackage Fabrik
* @copyright Copyright (C) 2005 Rob Clayburn. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

//require the abstract plugin classes
require_once(COM_FABRIK_FRONTEND . '/models/validation_rule.php');

class plgFabrik_validationruleIsgreaterorlessthan extends plgFabrik_Validationrule {

	var $_pluginName = 'isgreaterorlessthan';

	/** @param string classname used for formatting error messages generated by plugin */
	var $_className = 'notempty isgreaterthanorlessthan';

	/** @var bool if true uses icon of same name as validation, otherwise uses png icon specified by $icon */
	protected $icon = 'notempty';

	/**
	 * validate the elements data against the rule
	 * @param	string	data to check
	 * @param	object	element
	 * @param	int		plugin sequence ref
	 * @return	bool	true if validation passes, false if fails
	 */

	function validate($data, &$elementModel, $c)
	{
		//could be a dropdown with multivalues
		if (is_array($data))
		{
			$data = implode('', $data);
		}
 		$params = $this->getParams();
 		$formdata = $elementModel->getForm()->_formData;
 		$cond = $params->get('isgreaterorlessthan-greaterthan');
 		$cond = $cond[$c] == '1' ? '>' : '<';
 		$otherElementModel = $this->getOtherElement($elementModel, $c);
 		$otherFullName = $otherElementModel->getFullName(false, true, false);
 		$compare = JArrayHelper::getValue($formdata, $otherFullName.'_raw', JArrayHelper::getValue($formdata, $otherFullName, ''));
 		if ($this->allowEmpty($elementModel, $c) && ($data === '' || $compare === ''))
 		{
 			return true;
 		}
 		$res = $elementModel->greaterOrLessThan($data, $cond, $compare);
 		return $res;
	}

	/**
	* does the validation allow empty value?
	* Default is false, can be overrideen on per-validation basis (such as isnumeric)
	* @param	object	element model
	* @param	int		repeat group counter
	* @return	bool
	*/

	protected function allowEmpty($elementModel, $c)
	{
		$params = $this->getParams();
		$allow_empty = $params->get('isgreaterorlessthan-allow_empty');
		$allow_empty = $allow_empty[$c];
		return $allow_empty == '1';
	}

	private function getOtherElement($elementModel, $c)
	{
		$params = $this->getParams();
		$otherfield = (array)$params->get('isgreaterorlessthan-comparewith', array());
		$otherfield = $otherfield[$c];
		return FabrikWorker::getPluginManager()->getElementPlugin($otherfield);
	}

}
?>