<?php
/*
 * @package Joomla.Administrator
 * @subpackage Fabrik
 * @since		1.6
 * @copyright Copyright (C) 2005 Rob Clayburn. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * List controller class.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_fabrik
 * @since		1.6
 */
class FabrikControllerList extends JControllerForm
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_FABRIK_LIST';

	/**
	 * ajax load drop down of all columns in a given table
	 */

	public function ajax_loadTableDropDown()
	{
		$conn = JRequest::getInt('conn', 1);
		$oCnn = JModel::getInstance('Connection', 'FabrikFEModel');
		$oCnn->setId($conn);
		$oCnn->getConnection();
		$db = $oCnn->getDb();
		$table = JRequest::getVar('table', '');
		$fieldNames = array();
		if ($table != '') {
			$table = FabrikString::safeColName($table);
			$name = JRequest::getVar('name', 'jform[params][table_key][]');
			$sql = "DESCRIBE $table";
			$db->setQuery($sql);
			$aFields = $db->loadObjectList();

			if (is_array($aFields)) {
				foreach ($aFields as $oField) {
					$fieldNames[] = JHTML::_('select.option', $oField->Field);
				}
			}
		}
		$fieldDropDown = JHTML::_('select.genericlist', $fieldNames, $name, "class=\"inputbox\"  size=\"1\" ", 'value', 'text', '');
		echo $fieldDropDown;
	}
	
	function delete()
	{
		// Check for request forgeries
		JRequest::checkToken() or die('Invalid Token');
		$app = JFactory::getApplication();
		$model = JModel::getInstance('List', 'FabrikFEModel');
		$listid = JRequest::getInt('listid');
		$model->setId($listid);
		$ids = JRequest::getVar('ids', array(), 'request', 'array');
		$limitstart = JRequest::getVar('limitstart'. $listid);
		$length = JRequest::getVar('limit' . $listid);
		$oldtotal = $model->getTotalRecords();
		$model->deleteRows($ids);
		$total = $oldtotal - count($ids);
		if ($total >= $limitstart)
		{
			$newlimitstart = $limitstart - $length;
			if ($newlimitstart < 0)
			{
				$newlimitstart = 0;
			}
			$context = 'com_fabrik.list'.$model->getRenderContext().'.list.';
			$app->setUserState($context.'limitstart'.$listid, $newlimitstart);
		}
		JRequest::setVar('view', 'list');
		$this->view();
		
	}
	
	public function filter()
	{
				// Check for request forgeries
		//JRequest::checkToken() or die('Invalid Token');
		$model = JModel::getInstance('List', 'FabrikFEModel');
		$id = JRequest::getInt('listid');
		$model->setId($id);
		JRequest::setvar('cid', $id);
		$request = $model->getRequestData();
		$model->storeRequestData($request);
		$this->view();
	}
	
	/**
	* show the lists data in the admin
	*/
	
	public function view()
	{
		$cid = JRequest::getVar('cid', array(0), 'method', 'array');
		if(is_array($cid)){
			$cid = $cid[0];
		}
		$cid = JRequest::getInt('listid', $cid);
		// grab the model and set its id
		$model = JModel::getInstance('List', 'FabrikFEModel');
		$model->setState('list.id', $cid);
		$viewType	= JFactory::getDocument()->getType();
		//use the front end renderer to show the table
		$this->setPath('view', COM_FABRIK_FRONTEND.DS.'views');
	
		$viewLayout	= JRequest::getCmd('layout', 'default');
		$view = $this->getView($this->view_item, $viewType, '');
		$view->setModel($model, true);
		// Set the layout
		$view->setLayout($viewLayout);
		JToolBarHelper::title(JText::_('COM_FABRIK_MANAGER_LISTS'), 'lists.png');
		$view->display();
		FabrikHelper::addSubmenu(JRequest::getWord('view', 'lists'));
	}
}
