<?php
/**
 * @copyright Copyright (C) 2005 Rob Clayburn. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 */

// No direct access.
defined('_JEXEC') or die;

require_once('fabcontrolleradmin.php');

/**
 * Forms list controller class.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_fabrik
 * @since		1.6
 */
class FabrikControllerForms extends FabControllerAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */

	protected $text_prefix = 'COM_FABRIK_FORMS';

	protected $view_item = 'forms';

	/**
	 * Constructor.
	 *
	 * @param	array An optional associative array of configuration settings.
	 * @see		JController
	 * @since	1.6
	 */

	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	/**
	 * Proxy for getModel.
	 * @since	1.6
	 */

	public function &getModel($name = 'Form', $prefix = 'FabrikModel')
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}

	public function updateDatabase()
	{
		// Check for request forgeries
		JRequest::checkToken() or die('Invalid Token');
		$this->setRedirect('index.php?option=com_fabrik&view=forms');
		$this->getModel()->updateDatabase();
		$this->setMessage(JText::_('COM_FABRIK_DATABASE_UPDATED'));
	}
	
	public function listview()
	{
		$cid = JRequest::getVar('cid', array(0), 'method', 'array');
		if(is_array($cid)){
			$cid = $cid[0];
		}
		$db = JFactory::getDbo(true);
		$query = $db->getQuery(true);
		$query->select('id')->from('#__fabrik_lists')->where('form_id = '.(int)$cid);
		$db->setQuery($query);
		$listid = $db->loadResult();
		$this->setRedirect('index.php?option=com_fabrik&task=list.view&listid='.$listid);
	}

}